package com.example.tp6_03;


import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ListView;
import android.widget.ProgressBar;
import androidx.appcompat.app.AppCompatActivity;
import com.example.tp6_03.adapter.ListViewAdapterWeatherCondition;
import com.example.tp6_03.helper.Utils;
import com.example.tp6_03.model.City;
import com.example.tp6_03.service.RequestService;

public class MainActivity extends AppCompatActivity {

    City weatherCity = null;
    ProgressBar pb;
    EditText cityname;
    ListView weather_list;
    ListViewAdapterWeatherCondition adapter;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        cityname = (EditText) findViewById(R.id.city);
        weather_list = (ListView) findViewById(R.id.weather_list);
        pb = (ProgressBar) findViewById(R.id.progressBar);
        pb.setVisibility(ProgressBar.INVISIBLE);

        weatherCity = new City();
        adapter = new ListViewAdapterWeatherCondition(getApplicationContext(),R.layout.list_item,weatherCity.getWeather());
        weather_list.setAdapter(adapter);
        Button button = (Button) findViewById(R.id.button);
        button.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                String cityName = cityname.getText().toString();
                if(cityName.length() > 0) {
                    getCityWeatherConditions(Utils.URL_SERVICE_PREFIX + cityName + Utils.URL_SERVICE_SUFFIX);
                }
            }
        });

    }
    private void getCityWeatherConditions(String urlStr){
        pb.setVisibility(ProgressBar.VISIBLE);
        new Thread() {
            public void run() {
                try {
                weatherCity = RequestService.getCityWeatherConditions(urlStr);
                runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        if(weatherCity != null) {
                            cityname.setText(weatherCity.getName());
                            adapter.setItems(weatherCity.getWeather());
                            adapter.notifyDataSetChanged();
                        }
                        pb.setVisibility(ProgressBar.GONE);
                    }
                });
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }.start();
    }

    @Override
    protected void onPause() {
        super.onPause();

        Log.i("MAINACTIVITY","onPause");
    }
    @Override
    protected void onStop() {
        super.onStop();
        Log.i("MAINACTIVITY","onStop");
    }
}